/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.cache;

import com.solarterms.hakuro.web.data.redis.RedisClient;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class CacheUtils {
    private static final Object LOCK = new Object();
    private static final String NIL = "nil";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T get(String key, Supplier<T> supplier, Class<T> clazz) {
        Object o = RedisClient.get(key);
        if (o == null) {
            Object object = LOCK;
            synchronized (object) {
                Object obj = RedisClient.get(key);
                if (obj == null) {
                    T t = supplier.get();
                    if (t == null) {
                        RedisClient.set(key, NIL, 1L, TimeUnit.MINUTES);
                    } else {
                        RedisClient.set(key, t);
                    }
                    return t;
                }
            }
        }
        if (Objects.equals(o, NIL)) {
            return null;
        }
        return clazz.cast(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T get(String key, Supplier<T> supplier, Class<T> clazz, Long expire, TimeUnit timeUnit) {
        Object o = RedisClient.get(key);
        if (o == null) {
            Object object = LOCK;
            synchronized (object) {
                Object obj = RedisClient.get(key);
                if (obj == null) {
                    T t = supplier.get();
                    if (t == null) {
                        RedisClient.set(key, NIL, 1L, TimeUnit.MINUTES);
                    } else {
                        RedisClient.set(key, t, expire, timeUnit);
                    }
                    return t;
                }
            }
        }
        if (Objects.equals(o, NIL)) {
            return null;
        }
        return clazz.cast(o);
    }
}

