/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.web.bean.validation.annotation.MobileString;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class MobileStringConstraintValidator
implements ConstraintValidator<MobileString, String> {
    private final Pattern MOBILE_PATTERN = Pattern.compile("^1([3456789])\\d{9}$");

    public boolean isValid(String mobile, ConstraintValidatorContext constraintValidatorContext) {
        if (StringUtils.isEmpty((CharSequence)mobile)) {
            return false;
        }
        return this.MOBILE_PATTERN.matcher(mobile).matches();
    }

    public static void main(String[] args) {
        MobileStringConstraintValidator mobileStringConstraintValidator = new MobileStringConstraintValidator();
        System.out.println(mobileStringConstraintValidator.isValid("", null));
    }
}

