/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.framework.utils.function.StringUtils;
import com.solarterms.hakuro.web.bean.validation.annotation.LimitParam;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class LimitParamConstraintValidator
implements ConstraintValidator<LimitParam, String> {
    private int min;
    private int max;
    private boolean required;
    private boolean allowMb4;
    private LimitParam.ParamType type;

    public void initialize(LimitParam constraintAnnotation) {
        this.min = constraintAnnotation.min();
        this.max = constraintAnnotation.max();
        this.required = constraintAnnotation.required();
        this.type = constraintAnnotation.type();
        this.allowMb4 = constraintAnnotation.allowMb4();
    }

    public boolean isValid(String s, ConstraintValidatorContext constraintValidatorContext) {
        if (StringUtils.isEmpty((CharSequence)s) && this.required) {
            return false;
        }
        if (!this.allowMb4) {
            return !StringUtils.containsMb4Char((String)s);
        }
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            if (s.length() < this.min || s.length() > this.max) {
                return false;
            }
            if (LimitParam.ParamType.NUMBER.equals((Object)this.type)) {
                return NumberUtils.isParsable((String)s);
            }
        }
        return true;
    }
}

