/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.web.bean.validation.annotation.CollectionType;
import java.util.ArrayList;
import java.util.Collection;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class CollectionValidator
implements ConstraintValidator<CollectionType, Collection> {
    private int min;
    private int max;

    public void initialize(CollectionType constraintAnnotation) {
        this.min = constraintAnnotation.min();
        this.max = constraintAnnotation.max();
    }

    public boolean isValid(Collection collection, ConstraintValidatorContext constraintValidatorContext) {
        return null != collection && collection.size() >= this.min && collection.size() <= this.max;
    }

    public static void main(String[] args) {
        CollectionValidator validator = new CollectionValidator();
        System.out.println(validator.isValid(new ArrayList(), null));
    }
}

