/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.framework.utils.security.DBCAndSBSUtils;
import com.solarterms.hakuro.web.bean.validation.annotation.BracketsPairAppear;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class BracketsPairAppearConstraintValidator
implements ConstraintValidator<BracketsPairAppear, String> {
    public void initialize(BracketsPairAppear constraintAnnotation) {
    }

    public boolean isValid(String pairContent, ConstraintValidatorContext constraintValidatorContext) {
        char[] contentArray;
        pairContent = DBCAndSBSUtils.sbsToDbc((String)pairContent);
        int result = 0;
        boolean matchFlag = true;
        for (char aContentArray : contentArray = pairContent.toCharArray()) {
            if ('(' == aContentArray) {
                ++result;
                continue;
            }
            if (')' != aContentArray) continue;
            if (0 != result) {
                --result;
                continue;
            }
            matchFlag = false;
        }
        return 0 == result && matchFlag;
    }

    public static void main(String[] args) {
        BracketsPairAppearConstraintValidator x = new BracketsPairAppearConstraintValidator();
        System.out.println(x.isValid("\u666e\u4fe1\u6052\u4e1a\u79d1\u6280\u53d1\u5c55\uff08\u5317\u4eac)\u6709\u9650\u516c\u53f8", null));
    }
}

