/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.framework.core.bean.Log;
import com.solarterms.hakuro.framework.utils.function.StringUtils;
import com.solarterms.hakuro.web.bean.validation.annotation.BigDecimalString;
import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class BigDecimalStringConstraintValidator
implements ConstraintValidator<BigDecimalString, String> {
    private int max;
    private int scale;

    public void initialize(BigDecimalString ann) {
        this.max = ann.max();
        this.scale = ann.scale();
    }

    public boolean isValid(String bigDecimalString, ConstraintValidatorContext context) {
        if (StringUtils.isEmpty((CharSequence)bigDecimalString)) {
            return false;
        }
        if (StringUtils.startsWith((CharSequence)bigDecimalString, (CharSequence)".") || StringUtils.endsWith((CharSequence)bigDecimalString, (CharSequence)".")) {
            return false;
        }
        try {
            BigDecimal decimal = new BigDecimal(bigDecimalString);
            if (decimal.scale() > this.scale) {
                return false;
            }
            if (String.valueOf(decimal.longValue()).length() > this.max - this.scale) {
                return false;
            }
        }
        catch (Exception e) {
            Log.ERROR_LOGGER.error("\u6570\u5b57\u8f6c\u6362\u51fa\u9519:" + bigDecimalString);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        BigDecimal decimal = new BigDecimal("200");
        System.out.println(decimal.longValueExact());
    }
}

