/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.web.bean.validation.annotation.BankAccountString;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class BankAccountStringConstraintValidator
implements ConstraintValidator<BankAccountString, String> {
    private static final Pattern ALPHABET_OR_NUMBER_PATTERN = Pattern.compile("^\\d{6,20}$|^[A-Za-z]{6,20}$|^[0-9A-Za-z]{6,20}$");

    public void initialize(BankAccountString constraintAnnotation) {
    }

    public boolean isValid(String accountStr, ConstraintValidatorContext constraintValidatorContext) {
        if (StringUtils.isEmpty((CharSequence)accountStr)) {
            return false;
        }
        return ALPHABET_OR_NUMBER_PATTERN.matcher(accountStr).matches();
    }

    public static void main(String[] args) {
        BankAccountStringConstraintValidator x = new BankAccountStringConstraintValidator();
        System.out.println(x.isValid(null, null));
    }
}

