package com.solarterms.hakuro.web.plugins;

import com.solarterms.hakuro.framework.core.enums.BooleanTypeEnum;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.internal.types.JavaTypeResolverDefaultImpl;

/**
 * @author Created by Alan on 2021/5/19.
 */

public class JavaTypeResolver extends JavaTypeResolverDefaultImpl {

    private final String COLUMN_NAME = "delete_flag";


    @Override
    public FullyQualifiedJavaType calculateJavaType(IntrospectedColumn introspectedColumn) {
        if (COLUMN_NAME.equals(introspectedColumn.getActualColumnName())) {
            return new FullyQualifiedJavaType(BooleanTypeEnum.class
                    .getName());
        } else {
            return super.calculateJavaType(introspectedColumn);
        }
    }

    @Override
    public String calculateJdbcTypeName(IntrospectedColumn introspectedColumn) {
        if (COLUMN_NAME.equals(introspectedColumn.getActualColumnName())) {
            return BooleanTypeEnum.class.getSimpleName();
        } else {
            return super.calculateJdbcTypeName(introspectedColumn);
        }
    }
}