package com.solarterms.hakuro.web.id.config;

import com.solarterms.hakuro.web.data.redis.RedisUtils;
import com.solarterms.hakuro.web.id.core.IdGen;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.RedisTemplate;

/**
 * @author Created by Alan on 2021/5/19.
 */

@ConditionalOnBean(RedisTemplate.class)
@EnableConfigurationProperties(GeneratorProperties.class)
public class IdGenAutoConfiguration {

    private GeneratorProperties properties;

    public IdGenAutoConfiguration(GeneratorProperties properties) {
        this.properties = properties;
    }

    @Bean("idGen")
    public IdGen idGen(@Qualifier("redisTemplate") RedisTemplate redisTemplate) {
        if (properties.getShardingBits() + properties.getSeqBits() > 22) {
            throw new IllegalArgumentException("too long for the total sum of sharding-bits and seq-bits");
        }
        return new IdGen(nextSharding(redisTemplate), properties);
    }

    @SuppressWarnings("unchecked")
    private long nextSharding(RedisTemplate redisTemplate) {
        String shardingKey = String.format("%s-%s", RedisUtils.applicationCachePrefix(), "shardingKey");
        long shardingId = redisTemplate.opsForValue().increment(shardingKey, 1L);
        if (shardingId > (1L << properties.getShardingBits()) - 1) {
            redisTemplate.delete(shardingKey);
            shardingId = redisTemplate.opsForValue().increment(shardingKey, 1L);
        }
        return shardingId;
    }

}
