package com.solarterms.hakuro.web.http;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

/**
 * @author Created by Alan on 2021/5/19.
 */
public class RestTemplateCondition implements Condition {
    @Override
    public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
        String enable = conditionContext.getEnvironment().getProperty("rest-template.enable");
        if(StringUtils.isNotEmpty(enable)&&enable.equals("true")){
            return true;
        }
        return false;
    }
}
