package com.solarterms.hakuro.web.exception;


import com.solarterms.hakuro.framework.core.interfaces.Typeable;

/**
 * @author Created by Alan on 2021/5/19.
 */
public class FilterException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    private String code;

    private Object data;

    private Class clazz;

    public FilterException(Typeable typeBean) {
        this((String) typeBean.getCode(), typeBean.getMessage(),null,null);
    }

    public FilterException(Typeable typeBean, Object data, Class clazz) {
        this((String) typeBean.getCode(), typeBean.getMessage(),data,clazz);
    }

    public FilterException(String code, String message) {
        super(message);
        this.code = code;
        this.data = null;
        this.clazz = null;
    }

    public FilterException(String code, String message, Object data, Class clazz) {
        super(message);
        this.code = code;
        this.data = data;
        this.clazz = clazz;
    }

    public String getCode() {
        return code;
    }

    public Object getData() {
        return data;
    }

    public Class getClazz() {
        return clazz;
    }
}
