
package com.solarterms.hakuro.web.db.typehandler;

import com.solarterms.hakuro.framework.core.interfaces.Typeable;

import com.solarterms.hakuro.framework.utils.function.TypeBeanUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Created by Alan on 2021/5/19.
 */
public class TypeCodeTypeHandler<E extends Typeable> extends BaseTypeHandler<E> {

    private Class<E> type;
    private final Map<Object, E> enums;

    @SuppressWarnings({"unchecked", "rawtypes"})
    public TypeCodeTypeHandler(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type argument cannot be null");
        }

        List<E> enumList = TypeBeanUtils.getEnumList(type);
        Map<Object, E> temp = new HashMap<Object, E>();
        for (E each : enumList) {
            temp.put(each.getCode(), each);
        }
        this.type = type;
        enums = temp;
    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, E parameter,
                                    JdbcType jdbcType) throws SQLException {
        ps.setObject(i, parameter.getCode());
    }

    @Override
    public E getNullableResult(ResultSet rs, String columnName)
            throws SQLException {
        String code = rs.getString(columnName);
        if (rs.wasNull()) {
            return null;
        } else {
            try {
                return enums.get(code);
            } catch (Exception ex) {
                throw new IllegalArgumentException("Cannot convert " + code
                        + " to " + type.getSimpleName() + " by code value.", ex);
            }
        }
    }

    @Override
    public E getNullableResult(ResultSet rs, int columnIndex)
            throws SQLException {
        String code = rs.getString(columnIndex);
        if (rs.wasNull()) {
            return null;
        } else {
            try {
                return enums.get(code);
            } catch (Exception ex) {
                throw new IllegalArgumentException("Cannot convert " + code
                        + " to " + type.getSimpleName() + " by code value.", ex);
            }
        }
    }

    @Override
    public E getNullableResult(CallableStatement cs, int columnIndex)
            throws SQLException {
        String code = cs.getString(columnIndex);
        if (cs.wasNull()) {
            return null;
        } else {
            try {
                return enums.get(code);
            } catch (Exception ex) {
                throw new IllegalArgumentException("Cannot convert " + code
                        + " to " + type.getSimpleName() + " by code value.", ex);
            }
        }
    }
}
