package com.solarterms.hakuro.web.data.redis;

import com.fasterxml.jackson.databind.JavaType;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.lang.Nullable;

/**
 *
 * 自定义redis序列化器，当返回值无法被解析为JSON格式时，可以用当成String来获取
 * @author Created by Alan on 2021/5/19.
 */

@SuppressWarnings("unchecked")
public class JsonOrStringRedisSerializer<T> extends Jackson2JsonRedisSerializer<T> {

    public JsonOrStringRedisSerializer(Class<T> type) {
        super(type);
    }

    public JsonOrStringRedisSerializer(JavaType javaType) {
        super(javaType);
    }

    @Override
    public T deserialize(@Nullable byte[] bytes) throws SerializationException {
        try {
            return super.deserialize(bytes);
        } catch (SerializationException e) {
            return (T) deserializeString(bytes);
        }
    }

    private String deserializeString(@Nullable byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new String(bytes);
    }
}
