package com.solarterms.hakuro.web.common;

import com.solarterms.hakuro.framework.core.bean.Log;
import com.solarterms.hakuro.framework.utils.log.LogUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Created by Alan on 2021/5/19.
 */
public class ReflectionUtils extends org.springframework.util.ReflectionUtils {

    public static List<Object> getFields(Object obj) {
        return Arrays.stream(obj.getClass().getDeclaredFields()).map(field -> {
            makeAccessible(field);
            return getField(field, obj);
        }).collect(Collectors.toList());
    }

    public static String toString(Object obj) {
        try {
            String result = Arrays.stream(obj.getClass().getDeclaredFields()).map((field) -> {
                makeAccessible(field);
                return field.getName() + "=" + getField(field, obj);
            }).collect(Collectors.joining(","));
            return "(" + result + ")";
        } catch (Exception var2) {
            LogUtils.error(Log.MICRO_SERVICE_DIGEST_LOGGER, "对象反射格式化输出发生错误", var2);
            return "()";
        }
    }
}
