package com.solarterms.hakuro.web.cache;

import com.solarterms.hakuro.web.data.redis.RedisClient;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

/**
 * @author Created by Alan on 2021/5/19.
 */
public class CacheUtils {
    private final static Object LOCK = new Object();
    private final static String NIL = "nil";

    public static <T> T get(String key, Supplier<T> supplier, Class<T> clazz) {
        Object o = RedisClient.get(key);
        if (o == null) {
            //防止缓存击穿
            synchronized (LOCK) {
                Object obj = RedisClient.get(key);
                if (obj == null) {
                    T t = supplier.get();
                    if (t == null) {
                        RedisClient.set(key, NIL, 1, TimeUnit.MINUTES);
                    } else {
                        RedisClient.set(key, t);
                    }
                    return t;
                }
            }
        }
        if (Objects.equals(o, NIL)) {
            return null;
        }
        return clazz.cast(o);
    }

    public static <T> T get(String key, Supplier<T> supplier, Class<T> clazz, Long expire, TimeUnit timeUnit) {
        Object o = RedisClient.get(key);
        if (o == null) {
            //防止缓存击穿
            synchronized (LOCK) {
                Object obj = RedisClient.get(key);
                if (obj == null) {
                    T t = supplier.get();
                    if (t == null) {
                        RedisClient.set(key, NIL, 1, TimeUnit.MINUTES);
                    } else {
                        RedisClient.set(key, t, expire, timeUnit);
                    }
                    return t;
                }
            }
        }
        if (Objects.equals(o, NIL)) {
            return null;
        }
        return clazz.cast(o);
    }
}
