package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.URL;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

/**
 * @author Created by Alan on 2021/5/19.
 */
@Component
@Order(ComponentOrder.CUSTOM_VALIDATION)
public class URLConstraintValidator implements ConstraintValidator<URL, String> {

    private static final Pattern URL_PATTERN = Pattern.compile("^http[s]?://([\\w-]+\\.)+[\\w-]+([\\w-./?%&=#]*)?$");

    @Override
    public void initialize(URL constraintAnnotation) {
    }

    @Override
    public boolean isValid(String url, ConstraintValidatorContext constraintValidatorContext) {
        if (StringUtils.isEmpty(url)) {
            return false;
        }
        return URL_PATTERN.matcher(url).matches();
    }

    public static void main(String[] args) {
        URLConstraintValidator x = new URLConstraintValidator();
        System.out.println(x.isValid("http://www.baidu.com/notify/", null));
    }
}
