package com.solarterms.hakuro.web.bean.validation.validator;


import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.RegexParam;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

/**
 * @author Created by Alan on 2021/5/19.
 */
@Component
@Order(ComponentOrder.CUSTOM_VALIDATION)
public class RegexParamConstraintValidator implements ConstraintValidator<RegexParam, String> {

    private String regex;

    private boolean required;

    @Override
    public void initialize(RegexParam constraintAnnotation) {
        regex = constraintAnnotation.regex();
        required = constraintAnnotation.required();
    }

    @Override
    public boolean isValid(String s, ConstraintValidatorContext constraintValidatorContext) {
        return s == null ? !required : Pattern.compile(regex).matcher(s).matches();
    }
}
