package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.NumberString;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * @author Created by Alan on 2021/5/19.
 */
@Component
@Order(ComponentOrder.CUSTOM_VALIDATION)
public class NumberStringConstraintValidator implements ConstraintValidator<NumberString, String> {

    @Override
    public void initialize(NumberString constraintAnnotation) {
    }

    @Override
    public boolean isValid(String numberString, ConstraintValidatorContext constraintValidatorContext) {
        try {
            Double.valueOf(numberString);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

}
