package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.NotNullString;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * @author Created by Alan on 2021/5/19.
 */
@Component
@Order(ComponentOrder.BASIC_VALIDATION)
public class NotNullStringConstraintValidator implements ConstraintValidator<NotNullString, String> {

    @Override
    public void initialize(NotNullString constraintAnnotation) {
    }

    @Override
    public boolean isValid(String s, ConstraintValidatorContext constraintValidatorContext) {
        return !(StringUtils.isEmpty(s) || StringUtils.isBlank(s));
    }

    public static void main(String[] args) {
        NotNullStringConstraintValidator notNullStringConstraintValidator = new NotNullStringConstraintValidator();
        System.out.println(notNullStringConstraintValidator.isValid(null, null));
    }
}
