package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.NotNullList;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.List;

/**
 * @author Created by Alan on 2020/12/21.
 */

@Component
@Order(ComponentOrder.BASIC_VALIDATION)

public class NotNullListConstraintValidator implements ConstraintValidator<NotNullList, List> {

    @Override
    public boolean isValid(List list, ConstraintValidatorContext constraintValidatorContext) {
        return !(null == list || 0 == list.size());
    }

    @Override
    public void initialize(NotNullList constraintAnnotation) {

    }

    public static void main(String[] args) {

        List<String> list = null;

        NotNullListConstraintValidator notNullListConstraintValidator = new NotNullListConstraintValidator();
        System.out.println(notNullListConstraintValidator.isValid(list, null));
    }
}
