package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.framework.utils.function.StringUtils;
import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.LimitParam;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * @author Created by Alan on 2021/5/19.
 */
@Component
@Order(ComponentOrder.CUSTOM_VALIDATION)
public class LimitParamConstraintValidator implements ConstraintValidator<LimitParam, String> {

    private int min;

    private int max;

    private boolean required;

    private boolean allowMb4;

    private LimitParam.ParamType type;

    @Override
    public void initialize(LimitParam constraintAnnotation) {
        min = constraintAnnotation.min();
        max = constraintAnnotation.max();
        required = constraintAnnotation.required();
        type = constraintAnnotation.type();
        allowMb4 = constraintAnnotation.allowMb4();
    }

    @Override
    public boolean isValid(String s, ConstraintValidatorContext constraintValidatorContext) {
        if (StringUtils.isEmpty(s) && required) {
            return false;
        }
        if (!allowMb4) {
            return !StringUtils.containsMb4Char(s);
        }
        if (StringUtils.isNotEmpty(s)) {
            if (s.length() < min || s.length() > max) {
                return false;
            }
            if (LimitParam.ParamType.NUMBER.equals(type)) {
                return NumberUtils.isParsable(s);
            }
        }
        return true;
    }

}
