package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.framework.core.bean.Log;
import com.solarterms.hakuro.framework.utils.datetime.DateUtils;
import com.solarterms.hakuro.framework.utils.function.StringUtils;
import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.DateString;

import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * @author Created by Alan on 2021/5/19.
 */
@Component
@Order(ComponentOrder.CUSTOM_VALIDATION)
public class DateStringConstraintValidator implements ConstraintValidator<DateString, String> {

    private String format;
    private boolean required;
    private boolean blankValid;

    @Override
    public void initialize(DateString ann) {
        format = ann.format();
        required = ann.required();
        blankValid = ann.blankValid();
    }

    @Override
    public boolean isValid(String dateString, ConstraintValidatorContext context) {
        if (dateString == null) {
            return !required;
        }
        if (blankValid && StringUtils.isBlank(dateString)) {
            return true;
        }
        try {
            DateUtils.parseToDate(dateString, format);
            return true;
        } catch (Exception e) {
            Log.ERROR_LOGGER.error("日期转换出错:" + dateString);
            return false;
        }
    }

}
