package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.CollectionType;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.ArrayList;
import java.util.Collection;

/**
 * @author Created by Alan on 2021/5/19.
 */
@Component
@Order(ComponentOrder.CUSTOM_VALIDATION)
public class CollectionValidator implements ConstraintValidator<CollectionType, Collection> {

    private int min;

    private int max;

    @Override
    public void initialize(CollectionType constraintAnnotation) {
        this.min = constraintAnnotation.min();
        this.max = constraintAnnotation.max();
    }

    @Override
    public boolean isValid(Collection collection, ConstraintValidatorContext constraintValidatorContext) {
        return null != collection && collection.size() >= min && collection.size() <= max;
    }

    public static void main(String[] args) {
        CollectionValidator validator = new CollectionValidator();
        System.out.println(validator.isValid(new ArrayList<>(), null));
    }

}
