package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.framework.utils.security.DBCAndSBSUtils;
import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.BracketsPairAppear;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * @author Created by Alan on 2021/5/19.
 */
@Component
@Order(ComponentOrder.CUSTOM_VALIDATION)
public class BracketsPairAppearConstraintValidator implements ConstraintValidator<BracketsPairAppear, String> {

    @Override
    public void initialize(BracketsPairAppear constraintAnnotation) {
    }

    @Override
    public boolean isValid(String pairContent, ConstraintValidatorContext constraintValidatorContext) {
        pairContent = DBCAndSBSUtils.sbsToDbc(pairContent);
        int result = 0;
        boolean matchFlag = true;
        char[] contentArray = pairContent.toCharArray();

        for (char aContentArray : contentArray) {
            if ('(' == aContentArray) {
                result++;
            } else if (')' == aContentArray) {
                if ((0 != result)) {
                    result--;
                } else {
                    matchFlag = false;
                }
            }
        }
        return (0 == result && matchFlag);
    }

    public static void main(String[] args) {
        BracketsPairAppearConstraintValidator x = new BracketsPairAppearConstraintValidator();
        System.out.println(x.isValid("普信恒业科技发展（北京)有限公司", null));
    }
}
