package com.solarterms.hakuro.web.bean.validation.annotation;

import com.solarterms.hakuro.web.bean.validation.validator.NotNullListConstraintValidator;
import com.solarterms.hakuro.web.bean.validation.validator.NotNullStringConstraintValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author Created by Alan on 2020/12/21.
 */

@Target({ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(
        validatedBy = {NotNullListConstraintValidator.class}
)
public @interface NotNullList {

    String message() default "列表不允许为空";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
