package com.solarterms.hakuro.web.bean.validation.annotation;

import com.solarterms.hakuro.web.bean.validation.validator.LimitParamConstraintValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author Created by Alan on 2021/5/19.
 */
@Target({ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(
        validatedBy = {LimitParamConstraintValidator.class}
)
public @interface LimitParam {

    int min() default 0;

    int max() default Integer.MAX_VALUE;

    boolean required() default true;

    boolean allowMb4() default true;

    ParamType type() default ParamType.STRING;

    String message() default "非法参数";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

    enum ParamType {
        /**
         * 参数类型
         */
        STRING, NUMBER
    }


}
