package com.solarterms.hakuro.web.bean.validation.annotation;

import com.solarterms.hakuro.web.bean.validation.validator.BankCardStringConstraintValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

/**
 * @author Created by Alan on 2021/5/19.
 */
@Target({ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(
        validatedBy = {BankCardStringConstraintValidator.class}
)
public @interface BankCardString {

    String message() default "非法的银行卡号";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
