package com.solarterms.hakuro.web.bean.validation.annotation;

import com.solarterms.hakuro.web.bean.validation.validator.BankAccountStringConstraintValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

/**
 * @author Created by Alan on 2021/5/19.
 */
@Target({ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(
        validatedBy = {BankAccountStringConstraintValidator.class}
)
public @interface BankAccountString {

    String message() default "用户名不符合规范";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

}
