package com.solarterms.hakuro.web.id.core;

import com.solarterms.hakuro.web.id.config.GeneratorProperties;

public class IdGen {

    private GeneratorProperties properties;

    private long lastTimestamp;

    private long shardingId;

    private long sequenceId;

    public IdGen(long shardingId, GeneratorProperties properties) {
        this.properties = properties;
        this.lastTimestamp = 0L;
        this.shardingId = shardingId;
        this.sequenceId = 0L;
    }

    /**
     * 生成ID：41bit时间戳+分片+序号
     */
    public synchronized long next() {
        return next(System.currentTimeMillis());
    }

    private long next(long timestamp) {
        if (timestamp > lastTimestamp) {
            sequenceId = 0L;
            lastTimestamp = timestamp;
        } else if (timestamp == lastTimestamp) {
            if (sequenceId >= (1L << properties.getSeqBits()) - 1) {
                return next(tilNextMillis(lastTimestamp));
            } else {
                sequenceId++;
            }
        } else {
            throw new IllegalStateException("timestamp error");
        }
        return ((timestamp - properties.getStartTime()) << (properties.getShardingBits() + properties.getSeqBits()))
                | (shardingId << properties.getSeqBits())
                | sequenceId;
    }

    /**
     * 阻塞直到跳到下一毫秒
     */
    private long tilNextMillis(long current) {
        long next = System.currentTimeMillis();
        while (next <= current) {
            next = System.currentTimeMillis();
        }
        return next;
    }

}
