package com.solarterms.hakuro.web.http;

import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

import java.nio.charset.StandardCharsets;

/**
 * Created by IntelliJ IDEA
 * User: XiaoshanDu
 * Date: 17/9/18
 */
@Configuration
@Conditional(RestTemplateCondition.class)
@EnableConfigurationProperties({RestTemplateProperties.class})
public class RestTemplateAutoConfiguration {
    private RestTemplateProperties properties;

    public RestTemplateAutoConfiguration(RestTemplateProperties properties) {
        this.properties = properties;
    }

    @Bean
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate(this.httpRequestFactory());
        restTemplate.getMessageConverters().forEach(httpMessageConverter -> {
            if (httpMessageConverter instanceof StringHttpMessageConverter) {
                ((StringHttpMessageConverter) httpMessageConverter).setDefaultCharset(StandardCharsets.UTF_8);
            }
        });
        return restTemplate;
    }

    private HttpComponentsClientHttpRequestFactory httpRequestFactory() {
        PoolingHttpClientConnectionManager poolManager = new PoolingHttpClientConnectionManager();
        poolManager.setMaxTotal(properties.getMaxTotal());
        poolManager.setDefaultMaxPerRoute(properties.getMaxPerRoute());
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setConnectTimeout(properties.getConnectTimeout());
        factory.setReadTimeout(properties.getReadTimeout());
        factory.setConnectionRequestTimeout(properties.getConnectionRequestTimeout());
        SSLConnectionSocketFactory sf = new SSLConnectionSocketFactory(
                SSLContexts.createDefault(), new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"},
                null, SSLConnectionSocketFactory.getDefaultHostnameVerifier()
        );
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(sf).setConnectionManager(poolManager).build();
        factory.setHttpClient(httpClient);
        return factory;
    }


}
