package com.solarterms.hakuro.web.data.redis;

import com.solarterms.hakuro.web.context.util.ApplicationContextUtils;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

/**
 * @author : wangyonghua
 */
public class RedisUtils {
    public static String applicationCachePrefix() {
        return String.format("%s-%s",
                ApplicationContextUtils.getProperties("spring.application.name"),
                ApplicationContextUtils.getProperties("spring.profiles.active"));
    }

    /**
     * 有效时间的缓存获取对象
     *
     * @param key  缓存键
     * @param func 操作函数
     * @param <T>  对象
     * @return 对象
     */
    @SuppressWarnings("unchecked")
    public static <T> T get(String key, Supplier<T> func) {
        T obj = (T) RedisClient.get(key);
        if (obj == null) {
            obj = func.get();
            RedisClient.set(key, obj);
        }
        return obj;
    }

    /**
     * 有效时间的缓存获取对象
     *
     * @param key      缓存键
     * @param func     操作函数
     * @param expire   过期时间
     * @param timeUnit 单位
     * @param <T>      对象
     * @return 对象
     */
    @SuppressWarnings("unchecked")
    public static <T> T get(String key, Supplier<T> func, long expire, TimeUnit timeUnit) {
        T obj = (T) RedisClient.get(key);
        if (obj == null) {
            obj = func.get();
            RedisClient.set(key, obj, expire, timeUnit);
        }
        return obj;
    }
}
