package com.solarterms.hakuro.web.ctx;


import com.solarterms.hakuro.framework.utils.function.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * User: Alan
 * Date: 2017/12/8
 */
public class RequestContextHolder {

    private static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = org.springframework.web.context.request.RequestContextHolder.getRequestAttributes();
        return ((ServletRequestAttributes) requestAttributes).getRequest();
    }

    /**
     * 获取调用方法类型 GET/POST/PUT...
     */
    public static HttpMethod getMethodType() {
        return HttpMethod.resolve(getRequest().getMethod());
    }

    /**
     * 根据名字获取请求参数内容
     *
     * @param name 参数名字
     * @return String
     */
    public static String getParameter(String name) {
        HttpServletRequest request = getRequest();
        return request != null ? request.getParameter(name) : null;
    }

    /**
     * 根据header头的名字获取值
     *
     * @param name header 名字
     * @return String
     */
    public static String getHeader(String name) {
        HttpServletRequest request = getRequest();
        return request != null ? request.getHeader(name) : null;
    }

    /**
     * 获取所有header中所有值
     *
     * @return Map
     */
    public static Map<String, String> getHeaderMap() {
        Map<String, String> headerMap = new HashMap<>();
        HttpServletRequest request = getRequest();
        if (request != null) {
            Enumeration<String> names = request.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                headerMap.put(name, request.getHeader(name));
            }
        }
        return headerMap;
    }

    /**
     * 获取远程地址
     *
     * @return String
     */
    public static String getRemoteAddr() {
        HttpServletRequest request = getRequest();
        return request != null ? request.getRemoteAddr() : null;
    }

    /**
     * 获取请求路径
     *
     * @return String
     */
    public static String getPath() {
        HttpServletRequest request = getRequest();
        return request != null ? request.getServletPath() : null;
    }

    /**
     * 获取完整Url
     *
     * @return String
     */
    public static String getUrl() {
        HttpServletRequest request = getRequest();
        if (request != null) {
            String orgUrl = request.getHeader("request_url");
            if (!StringUtils.isEmpty(orgUrl)) {
                // 请求头还有原始URL信息
                return orgUrl;
            }
            StringBuffer url = request.getRequestURL();
            if (!StringUtils.isEmpty(request.getQueryString())) {
                url.append('?');
                url.append(request.getQueryString());
            }
            return url.toString();
        }
        return null;
    }

}
