package com.solarterms.hakuro.web.context.util;

import com.solarterms.hakuro.framework.core.bean.Log;
import com.solarterms.hakuro.framework.utils.log.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertyHelper {

    public static String getProperty(String key, String file) {
        InputStream in = PropertyHelper.class.getResourceAsStream(file);

        Properties prop = new Properties();
        try {
            prop.load(in);
        } catch (IOException e) {
            LogUtils.error(Log.ERROR_LOGGER, "[读取配置文件失败，请检查路径与文件名]-->" + file, e);
        }
        return prop.getProperty(key);
    }
}
