package com.solarterms.hakuro.web.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.solarterms.hakuro.framework.core.bean.Log;
import com.solarterms.hakuro.framework.utils.log.LogUtils;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

/**
 * @author : wangyonghua
 * @date Date : 2020/10/21 10:17
 */
public class MemoryCache {
    private Cache<String, Object> cacheManager;

    public MemoryCache() {
        cacheManager = CacheBuilder.newBuilder().build();
    }

    public MemoryCache(Long duration, TimeUnit timeUnit) {
        cacheManager = CacheBuilder.newBuilder().expireAfterWrite(duration, timeUnit).build();
    }

    public <T> T get(String key, Supplier<T> supplier, Class<T> clazz) {
        try {
            Object o = cacheManager.get(key, supplier::get);
            return clazz.cast(o);
        } catch (Exception e) {
            LogUtils.error(Log.ERROR_LOGGER, "获取缓存发送异常", e);
            return null;
        }
    }
}
