package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.URL;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

/**
 * Created by IntelliJ IDEA
 * User: XiaoshanDu
 * Date: 2017/11/9
 */
@Component
@Order(ComponentOrder.CUSTOM_VALIDATION)
public class URLConstraintValidator implements ConstraintValidator<URL, String> {

    private static final Pattern URL_PATTERN = Pattern.compile("^http[s]?://([\\w-]+\\.)+[\\w-]+([\\w-./?%&=#]*)?$");

    @Override
    public void initialize(URL constraintAnnotation) {
    }

    @Override
    public boolean isValid(String url, ConstraintValidatorContext constraintValidatorContext) {
        if (StringUtils.isEmpty(url)) {
            return false;
        }
        return URL_PATTERN.matcher(url).matches();
    }

    public static void main(String[] args) {
        URLConstraintValidator x = new URLConstraintValidator();
        System.out.println(x.isValid("http://www.baidu.com/notify/", null));
    }
}
