package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.framework.core.interfaces.Typeable;
import com.solarterms.hakuro.framework.utils.function.TypeBeanUtils;
import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.TypeBeanCode;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * Created by IntelliJ IDEA
 * User: XiaoshanDu
 * Date: 2017/11/9
 */
@Component
@Order(ComponentOrder.CUSTOM_VALIDATION)
public class TypeBeanConstraintValidator implements ConstraintValidator<TypeBeanCode, String> {

    private boolean required;

    private Class<? extends Typeable> type;

    @Override
    public void initialize(TypeBeanCode ann) {
        required = ann.required();
        type = ann.type();
    }

    @Override
    public boolean isValid(String code, ConstraintValidatorContext context) {
        return code == null ? !required : TypeBeanUtils.getTypeByCode(type, code) != null;
    }
}
