package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.OnlineBankPwdString;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

/**
 * 网银登录密码校验
 * @author huangzhibo
 */
@Component
@Order(ComponentOrder.CUSTOM_VALIDATION)
public class OnlineBankPwdStringConstraintValidator implements ConstraintValidator<OnlineBankPwdString, String> {

    private static final Pattern ALPHABET_OR_NUMBER_PATTERN = Pattern.compile("^[0-9A-Za-z]{6,20}$");

    @Override
    public void initialize(OnlineBankPwdString constraintAnnotation) {
    }

    @Override
    public boolean isValid(String pwd, ConstraintValidatorContext constraintValidatorContext) {
        return StringUtils.isNotEmpty(pwd) && StringUtils.isNoneBlank(pwd) && ALPHABET_OR_NUMBER_PATTERN.matcher(pwd).matches();
    }

}
