package com.solarterms.hakuro.web.bean.validation.validator;


import com.solarterms.hakuro.framework.core.bean.Log;
import com.solarterms.hakuro.framework.core.bean.Money;
import com.solarterms.hakuro.framework.utils.function.StringUtils;
import com.solarterms.hakuro.framework.utils.math.MoneyUtils;
import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.MoneyString;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * Created by IntelliJ IDEA
 * User: XiaoshanDu
 * Date: 2017/11/9
 */
@Component
@Order(ComponentOrder.CUSTOM_VALIDATION)
public class MoneyStringConstraintValidator implements ConstraintValidator<MoneyString, String> {

    private int max;

    @Override
    public void initialize(MoneyString ann) {
        this.max = ann.max();
    }

    @Override
    public boolean isValid(String moneyString, ConstraintValidatorContext context) {
        if (StringUtils.isEmpty(moneyString)) {
            return false;
        }
        if (StringUtils.startsWith(moneyString, ".") || StringUtils.endsWith(moneyString, ".")) {
            return false;
        }
        try {
            Money money = MoneyUtils.createMoney(moneyString);
            if (String.valueOf(money.longValue()).length() > max - 2) {
                return false;
            }
        } catch (Exception e) {
            Log.ERROR_LOGGER.error("金额转换出错:" + moneyString);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        MoneyStringConstraintValidator x = new MoneyStringConstraintValidator();
        System.out.println(x.isValid("200", null));
    }

}
