package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.MobileString;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

/*
 *
 * User: Alan
 * Date: 2017/11/9
 */

/**
 * 手机号码校验注解类
 */
@Component
@Order(ComponentOrder.CUSTOM_VALIDATION)
public class MobileStringConstraintValidator implements ConstraintValidator<MobileString, String> {

    private Pattern MOBILE_PATTERN = Pattern.compile("^1([3456789])\\d{9}$");

    @Override
    public void initialize(MobileString constraintAnnotation) {
    }

    @Override
    public boolean isValid(String mobile, ConstraintValidatorContext constraintValidatorContext) {
        if (StringUtils.isEmpty(mobile)) {
            return false;
        }
        return MOBILE_PATTERN.matcher(mobile).matches();
    }

    public static void main(String[] args) {
        MobileStringConstraintValidator mobileStringConstraintValidator = new MobileStringConstraintValidator();
        System.out.println(mobileStringConstraintValidator.isValid("", null));
    }
}
