package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.framework.core.bean.Log;
import com.solarterms.hakuro.framework.utils.function.StringUtils;
import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.BigDecimalString;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.math.BigDecimal;

/**
 * Created by IntelliJ IDEA
 * User: XiaoshanDu
 * Date: 2017/11/9
 */
@Component
@Order(ComponentOrder.CUSTOM_VALIDATION)
public class BigDecimalStringConstraintValidator implements ConstraintValidator<BigDecimalString, String> {

    private int max;

    private int scale;

    @Override
    public void initialize(BigDecimalString ann) {
        this.max = ann.max();
        this.scale = ann.scale();
    }

    @Override
    public boolean isValid(String bigDecimalString, ConstraintValidatorContext context) {

        if (StringUtils.isEmpty(bigDecimalString)) {
            return false;
        }

        if (StringUtils.startsWith(bigDecimalString, ".") || StringUtils.endsWith(bigDecimalString, ".")) {
            return false;
        }

        try {
            BigDecimal decimal = new BigDecimal(bigDecimalString);

            if (decimal.scale() > scale) {
                return false;
            }

            if (String.valueOf(decimal.longValue()).length() > (max - scale)) {
                return false;
            }
        } catch (Exception e) {
            Log.ERROR_LOGGER.error("数字转换出错:" + bigDecimalString);
            return false;
        }

        return true;
    }

    public static void main(String[] args) {
        BigDecimal decimal = new BigDecimal("200");
        System.out.println(decimal.longValueExact());
    }

}
