package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.BankCardString;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * 银行卡号码校验
 * @author huangzhibo
 */
@Component
@Order(ComponentOrder.CUSTOM_VALIDATION)
public class BankCardStringConstraintValidator implements ConstraintValidator<BankCardString, String> {

    @Override
    public void initialize(BankCardString constraintAnnotation) {
    }

    @Override
    public boolean isValid(String bankCardString, ConstraintValidatorContext constraintValidatorContext) {
        return StringUtils.isNotEmpty(bankCardString) && StringUtils.isNoneBlank(bankCardString) && bankCardString.matches("\\d{0,19}$");
    }

}
