package com.solarterms.hakuro.web.bean.validation.validator;

import com.solarterms.hakuro.web.bean.order.ComponentOrder;
import com.solarterms.hakuro.web.bean.validation.annotation.BankAccountString;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

/**
 * @author huangzhibo
 * @date 14/12/2017
 */
@Component
@Order(ComponentOrder.CUSTOM_VALIDATION)
public class BankAccountStringConstraintValidator implements ConstraintValidator<BankAccountString, String> {

    private static final Pattern ALPHABET_OR_NUMBER_PATTERN = Pattern.compile("^\\d{6,20}$|^[A-Za-z]{6,20}$|^[0-9A-Za-z]{6,20}$");

    @Override
    public void initialize(BankAccountString constraintAnnotation) {
    }

    @Override
    public boolean isValid(String accountStr, ConstraintValidatorContext constraintValidatorContext) {
        if (StringUtils.isEmpty(accountStr)) {
            return false;
        }
        return ALPHABET_OR_NUMBER_PATTERN.matcher(accountStr).matches();
    }

    public static void main(String[] args) {
        BankAccountStringConstraintValidator x = new BankAccountStringConstraintValidator();
        System.out.println(x.isValid(null, null));
    }

}
