package com.solarterms.hakuro.web.bean.validation.config;

import com.solarterms.hakuro.framework.core.bean.Log;
import com.solarterms.hakuro.framework.utils.log.LogUtils;
import org.apache.bval.jsr.ApacheValidationProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

import javax.validation.ValidatorFactory;

/**
 * Created by IntelliJ IDEA
 *
 * @author xiaoshandu
 */
@ConditionalOnClass({ValidatorFactory.class})
public class ValidationAutoConfiguration {

    public static final String DEF_NAME = "validator";

    @Bean(name = DEF_NAME)
    public LocalValidatorFactoryBean localValidatorFactoryBean() {
        LogUtils.info(Log.RUNNER_DIGEST_LOGGER,"初始化参数校验[Validator]");
        LocalValidatorFactoryBean localValidatorFactoryBean = new LocalValidatorFactoryBean();
        localValidatorFactoryBean.setProviderClass(ApacheValidationProvider.class);
        return localValidatorFactoryBean;
    }

}
