package com.solarterms.hakuro.web.bean.validation.annotation;

import com.solarterms.hakuro.web.bean.validation.validator.NotNullStringConstraintValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/*
 *
 * User: Alan
 * Date: 2017/11/16
 */

@Target({ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(
        validatedBy = {NotNullStringConstraintValidator.class}
)
public @interface NotNullString {

    String message() default "字段不允许为空";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
