package com.solarterms.hakuro.web.bean.validation.annotation;

import com.solarterms.hakuro.web.bean.validation.validator.MobileStringConstraintValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/*
 *
 * User: Alan
 * Date: 2017/11/9
 */
@Target({ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(
        validatedBy = {MobileStringConstraintValidator.class}
)
public @interface MobileString {

    String message() default "非法的手机号码";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

}
