package com.solarterms.hakuro.web.bean.validation.annotation;

import com.solarterms.hakuro.web.bean.validation.validator.CollectionValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

/**
 * Created by IntelliJ IDEA
 * User: xiaoshandu
 * Date: 2018/5/23
 */
@Target({ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(
        validatedBy = {CollectionValidator.class}
)
public @interface CollectionType {

    int min() default 0;

    int max() default Integer.MAX_VALUE;

    String message() default "非法的列表入参";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

}
