/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.framework.utils.security;

import com.solarterms.hakuro.framework.utils.converter.BeanUtils;
import com.solarterms.hakuro.framework.utils.function.StringUtils;
import com.solarterms.hakuro.framework.utils.security.Base64Utils;
import java.beans.PropertyDescriptor;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.TreeMap;

public class SignatureUtils {
    public static final String DEF_SIGN_TYPE = "RSA";
    public static final String DEF_SIGN_ALGORITHMS = "SHA1WithRSA";
    private static final String DEF_KEY_FACTORY = "RSA";

    public static String sign(String privateKey, Object arg) {
        return SignatureUtils.sign(privateKey, SignatureUtils.getContent(arg));
    }

    public static boolean verify(String publicKey, Object arg, String sign) {
        return SignatureUtils.verify(publicKey, SignatureUtils.getContent(arg), sign);
    }

    public static String getContent(Object arg) {
        PropertyDescriptor[] fields = BeanUtils.getPropertyDescriptors(arg.getClass());
        TreeMap<String, String> dataSignMap = new TreeMap<String, String>();
        for (PropertyDescriptor field : fields) {
            String key = field.getName();
            String value = BeanUtils.getPropertyString(arg, key);
            dataSignMap.put(key, value);
        }
        StringBuilder signSb = new StringBuilder();
        for (Map.Entry entry : dataSignMap.entrySet()) {
            if (StringUtils.equals((CharSequence)"sign", (CharSequence)((CharSequence)entry.getKey())) || StringUtils.equals((CharSequence)"signType", (CharSequence)((CharSequence)entry.getKey())) || StringUtils.equals((CharSequence)"class", (CharSequence)((CharSequence)entry.getKey())) || StringUtils.isEmpty((CharSequence)((CharSequence)entry.getValue()))) continue;
            signSb.append((String)entry.getKey());
            signSb.append("=");
            signSb.append((String)entry.getValue());
            signSb.append("&");
        }
        if (signSb.length() > 0) {
            signSb.deleteCharAt(signSb.length() - 1);
        }
        return signSb.toString();
    }

    public static String sign(String privateKey, String content) {
        return SignatureUtils.sign(privateKey, content, "UTF-8");
    }

    public static String sign(String privateKey, String content, String encode) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64Utils.decode(privateKey));
            KeyFactory key = KeyFactory.getInstance("RSA");
            PrivateKey priKey = key.generatePrivate(priPKCS8);
            Signature signature = Signature.getInstance(DEF_SIGN_ALGORITHMS);
            signature.initSign(priKey);
            signature.update(content.getBytes(encode));
            byte[] signed = signature.sign();
            return Base64Utils.encode(signed);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean verify(String publicKey, String content, String sign) {
        return SignatureUtils.verify(publicKey, content, sign, "UTF-8");
    }

    public static boolean verify(String publicKey, String content, String sign, String encode) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            byte[] encodedKey = Base64Utils.decode(publicKey);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance(DEF_SIGN_ALGORITHMS);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(encode));
            return signature.verify(Base64Utils.decode(sign));
        }
        catch (Exception e) {
            return false;
        }
    }
}

