/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.framework.utils.security;

import com.solarterms.hakuro.framework.core.annotation.SensitiveInfo;
import com.solarterms.hakuro.framework.core.bean.Log;
import com.solarterms.hakuro.framework.core.enums.SensitiveTypeEnum;
import com.solarterms.hakuro.framework.core.interfaces.Typeable;
import com.solarterms.hakuro.framework.utils.function.StringUtils;
import com.solarterms.hakuro.framework.utils.log.LogUtils;
import com.solarterms.hakuro.framework.utils.security.SensitiveHandler;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public final class SensitiveUtils {
    private static Field[] findAllField(Class<?> clazz) {
        Object[] fields = clazz.getDeclaredFields();
        while (null != clazz.getSuperclass() && !Object.class.equals(clazz.getSuperclass())) {
            fields = (Field[])ArrayUtils.addAll((Object[])fields, (Object[])clazz.getSuperclass().getDeclaredFields());
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    private static boolean isComplexObject(Object obj) {
        Class<?> clazz = obj.getClass();
        return clazz.isArray() || !clazz.isPrimitive() && !(obj instanceof Typeable) && !StringUtils.startsWith((CharSequence)clazz.getPackage().getName(), (CharSequence)"javax.") && !StringUtils.startsWith((CharSequence)clazz.getPackage().getName(), (CharSequence)"java.") && !StringUtils.startsWith((CharSequence)clazz.getName(), (CharSequence)"javax.") && !StringUtils.startsWith((CharSequence)clazz.getName(), (CharSequence)"java.");
    }

    public static void sensitiveHandle(Object obj) {
        block6: {
            Field[] fields;
            SensitiveInfo annotation;
            Class<?> clazz;
            block8: {
                block7: {
                    block5: {
                        if (obj == null) {
                            return;
                        }
                        clazz = obj.getClass();
                        if (!clazz.isArray()) break block5;
                        for (int i = 0; i < Array.getLength(obj); ++i) {
                            Object item = Array.get(obj, i);
                            SensitiveUtils.sensitiveHandle(item);
                        }
                        break block6;
                    }
                    if (!(obj instanceof Collection)) break block7;
                    Collection c = (Collection)obj;
                    for (Object item : c) {
                        SensitiveUtils.sensitiveHandle(item);
                    }
                    break block6;
                }
                if (!(obj instanceof Map)) break block8;
                Map m = (Map)obj;
                for (Map.Entry entry : m.entrySet()) {
                    Object item = entry.getValue();
                    SensitiveUtils.sensitiveHandle(item);
                }
                break block6;
            }
            if (!SensitiveUtils.isComplexObject(obj) || (annotation = clazz.getAnnotation(SensitiveInfo.class)) == null || (fields = SensitiveUtils.findAllField(clazz)) == null) break block6;
            for (Field field : fields) {
                SensitiveUtils.sensitiveHandle(obj, field);
            }
        }
    }

    private static void sensitiveHandle(Object obj, Field field) {
        block12: {
            if (obj == null || field == null) {
                return;
            }
            try {
                field.setAccessible(true);
                Object value = field.get(obj);
                if (value == null) break block12;
                if (field.getType().isArray()) {
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        Object item = Array.get(value, i);
                        if (item == null || !SensitiveUtils.isComplexObject(item)) {
                            SensitiveUtils.handle(obj, field, value);
                            break block12;
                        }
                        SensitiveUtils.sensitiveHandle(item);
                    }
                    break block12;
                }
                if (value instanceof Collection) {
                    Collection c = (Collection)value;
                    for (Object item : c) {
                        if (item != null && SensitiveUtils.isComplexObject(item)) {
                            SensitiveUtils.sensitiveHandle(item);
                            continue;
                        }
                        SensitiveUtils.handle(obj, field, value);
                        break block12;
                    }
                    break block12;
                }
                if (value instanceof Map) {
                    Map m = (Map)value;
                    for (Map.Entry entry : m.entrySet()) {
                        Object item = entry.getValue();
                        if (item != null && SensitiveUtils.isComplexObject(item)) {
                            SensitiveUtils.sensitiveHandle(item);
                            continue;
                        }
                        SensitiveUtils.handle(obj, field, value);
                        break block12;
                    }
                    break block12;
                }
                SensitiveUtils.handle(obj, field, value);
            }
            catch (Exception e) {
                LogUtils.error(Log.CTRL_DIGEST_LOGGER, e, "\u8131\u654f\u5904\u7406\u5f02\u5e38");
            }
        }
    }

    private static void handle(Object obj, Field field, Object value) throws IllegalAccessException {
        SensitiveInfo annotation = field.getAnnotation(SensitiveInfo.class);
        if (annotation != null) {
            SensitiveTypeEnum type = annotation.value();
            if (value instanceof String) {
                String newValue = SensitiveUtils.stringTrans((String)value, type);
                field.set(obj, newValue);
            } else if (!field.getType().isPrimitive()) {
                Object newObj = SensitiveUtils.objectTrans(value, type);
                field.set(obj, newObj);
            }
        } else {
            SensitiveUtils.sensitiveHandle(value);
        }
    }

    private static String stringTrans(String value, SensitiveTypeEnum type) {
        switch (type) {
            case HEADER: {
                return SensitiveHandler.header(value);
            }
            case CHINESE_NAME: {
                return SensitiveHandler.chineseName(value);
            }
            case ID_CARD: {
                return SensitiveHandler.idCardNum(value);
            }
            case FIXED_PHONE: {
                return SensitiveHandler.fixedPhone(value);
            }
            case MOBILE_PHONE: {
                return SensitiveHandler.mobilePhone(value);
            }
            case EMAIL: {
                return SensitiveHandler.email(value);
            }
            case ADDRESS: {
                return SensitiveHandler.address(value);
            }
            case BANK_CARD: {
                return SensitiveHandler.bankCard(value);
            }
            case WECHAT: {
                return SensitiveHandler.wechat(value);
            }
            case LONG_STR: {
                return SensitiveHandler.longStr(value);
            }
            case FULL: {
                return SensitiveHandler.full(value);
            }
            case BLANK: {
                return "";
            }
        }
        return value;
    }

    private static Object objectTrans(Object value, SensitiveTypeEnum type) {
        switch (type) {
            case BLANK: {
                return null;
            }
        }
        return value;
    }
}

