/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.framework.utils.security;

import com.solarterms.hakuro.framework.core.bean.Log;
import com.solarterms.hakuro.framework.utils.log.LogUtils;
import com.solarterms.hakuro.framework.utils.security.Base64Utils;
import com.solarterms.hakuro.framework.utils.security.EncodingUtils;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class RsaUtils {
    public static final String ALGORITHMS = "RSA";
    private static final String KEY_ALGORITHM = "RSA";
    public static final String PUBLIC_KEY_NAME = "publicKey";
    public static final String PRIVATE_KEY_NAME = "privateKey";
    private static final String SIGN_ALGORITHMS = "SHA1WithRSA";
    private static final String SIGN2_ALGORITHMS = "SHA256WithRSA";
    private static final String CHARSET_NAME = "UTF-8";
    public static final int KEY_SIZE = 1024;

    public static Map<String, byte[]> genKeyPairBytes() {
        HashMap<String, byte[]> keyMap = new HashMap<String, byte[]>();
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(1024, new SecureRandom());
            KeyPair pair = gen.generateKeyPair();
            keyMap.put(PUBLIC_KEY_NAME, pair.getPublic().getEncoded());
            keyMap.put(PRIVATE_KEY_NAME, pair.getPrivate().getEncoded());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        return keyMap;
    }

    public static Map<String, String> genKeyPair() {
        HashMap<String, String> strKeyMap = new HashMap<String, String>();
        Map<String, byte[]> keyMap = RsaUtils.genKeyPairBytes();
        strKeyMap.put(PUBLIC_KEY_NAME, Base64Utils.encode(keyMap.get(PUBLIC_KEY_NAME)));
        strKeyMap.put(PRIVATE_KEY_NAME, Base64Utils.encode(keyMap.get(PRIVATE_KEY_NAME)));
        return strKeyMap;
    }

    public static String encryptByPublicKey(String publicKey, String plainText) {
        byte[] publicKeyBytes = Base64Utils.decode(publicKey);
        byte[] textBytes = EncodingUtils.encode(plainText);
        byte[] encryptedBytes = RsaUtils.encryptByPublicKey(publicKeyBytes, textBytes);
        return Base64Utils.encode(encryptedBytes);
    }

    public static byte[] encryptByPublicKey(byte[] publicKeyBytes, byte[] plainText) {
        try {
            PublicKey publicKey = RsaUtils.getPublicKey(publicKeyBytes);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            byte[] encryptedBytes = cipher.doFinal(plainText);
            return encryptedBytes;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String decryptByPrivateKey(String privatKey, String encryptedText) {
        byte[] privateKeyBytes = Base64Utils.decode(privatKey);
        byte[] encryptedBytes = Base64Utils.decode(encryptedText);
        byte[] decryptedBytes = RsaUtils.decryptByPrivateKey(privateKeyBytes, encryptedBytes);
        return EncodingUtils.decode(decryptedBytes);
    }

    public static byte[] decryptByPrivateKey(byte[] privateKeyBytes, byte[] encryptedBytes) {
        try {
            PrivateKey privateKey = RsaUtils.getPrivateKey(privateKeyBytes);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
            return decryptedBytes;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static PublicKey getPublicKey(byte[] keyBytes) throws InvalidKeySpecException, NoSuchAlgorithmException {
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = factory.generatePublic(x509EncodedKeySpec);
            return publicKey;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static PrivateKey getPrivateKey(byte[] keyBytes) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = factory.generatePrivate(pkcs8EncodedKeySpec);
        return privateKey;
    }

    public static String signByPrivate(String content, String privateKey) {
        try {
            PrivateKey priKey = RsaUtils.getPrivateKey(Base64Utils.decode(privateKey));
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(priKey);
            signature.update(content.getBytes(CHARSET_NAME));
            byte[] signed = signature.sign();
            return Base64Utils.encode(signed);
        }
        catch (Exception e) {
            LogUtils.error(Log.ERROR_LOGGER, "rsa\u52a0\u5bc6\u5931\u8d25:" + e);
            return null;
        }
    }

    public static String sign2ByPrivate(String content, String privateKey) {
        try {
            PrivateKey priKey = RsaUtils.getPrivateKey(Base64Utils.decode(privateKey));
            Signature signature = Signature.getInstance(SIGN2_ALGORITHMS);
            signature.initSign(priKey);
            signature.update(content.getBytes(CHARSET_NAME));
            byte[] signed = signature.sign();
            return Base64Utils.encode(signed);
        }
        catch (Exception e) {
            LogUtils.error(Log.ERROR_LOGGER, "rsa\u52a0\u5bc6\u5931\u8d25:" + e);
            return null;
        }
    }

    public static void main(String[] args) {
        Map<String, String> keyPair = RsaUtils.genKeyPair();
        System.out.println(keyPair.get(PUBLIC_KEY_NAME));
        System.out.println(keyPair.get(PRIVATE_KEY_NAME));
    }
}

