/*
 * Decompiled with CFR 0.152.
 */
package com.solarterms.hakuro.framework.utils.security;

import com.solarterms.hakuro.framework.utils.security.Base64Utils;
import com.solarterms.hakuro.framework.utils.security.EncodingUtils;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class DesedeUtils {
    public static final String ALGORITHM = "DESede/ECB/PKCS5Padding";
    private static final String KEY_ALGORITHM = "DESede";

    public static String encrypt(String key, String plainText) {
        byte[] keyBytes = Base64Utils.decode(key);
        byte[] textBytes = EncodingUtils.encode(plainText);
        byte[] encryptedBytes = DesedeUtils.encrypt(keyBytes, textBytes);
        return Base64Utils.encode(encryptedBytes);
    }

    public static String decrypt(String key, String encryptedText) {
        byte[] keyBytes = Base64Utils.decode(key);
        byte[] encryptedBytes = Base64Utils.decode(encryptedText);
        byte[] textBytes = DesedeUtils.decrypt(keyBytes, encryptedBytes);
        return EncodingUtils.decode(textBytes);
    }

    public static byte[] encrypt(byte[] key, byte[] src) {
        try {
            SecretKeySpec deskey = new SecretKeySpec(key, KEY_ALGORITHM);
            Cipher c1 = Cipher.getInstance(ALGORITHM);
            c1.init(1, deskey);
            return c1.doFinal(src);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static byte[] decrypt(byte[] key, byte[] src) {
        try {
            SecretKeySpec deskey = new SecretKeySpec(key, KEY_ALGORITHM);
            Cipher c1 = Cipher.getInstance(ALGORITHM);
            c1.init(2, deskey);
            return c1.doFinal(src);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getKey() {
        return Base64Utils.encode(DesedeUtils.getKeyBytes());
    }

    public static byte[] getKeyBytes() {
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        kg.init(168);
        SecretKey secretKey = kg.generateKey();
        byte[] keyBytes = secretKey.getEncoded();
        if (keyBytes.length != 24) {
            throw new IllegalArgumentException("key length is invaid!");
        }
        return keyBytes;
    }

    public static void main(String[] args) throws Exception {
        String key = DesedeUtils.getKey();
        System.out.println(key);
    }
}

